# Problem 2

Note: All information provided during the recruiting process is confidential. Any unauthorized use, disclosure or distribution of information is prohibited, including, but not limited to, discussion with others and/or posting on websites or public message boards.

# Problem description

You are given a network of computer nodes. There are N nodes and they are identified by integers from 1 to N. Some pairs of nodes are connected. Two nodes can communicate with each other if they are directly connected, or reachable by traversing several connections.

Nodes that can communicate with each other are part of the same group. For example, consider a 5-node network with connections between nodes 1-2, nodes 3-5, and nodes 4-5. In this network there are two groups: one is {1, 2} and the other is {3, 4, 5}. Note that nodes 3 and 4 are in the same group because they can communicate by traversing two connections.

Your task is to output the sizes of all groups, in descending order.

## Input

Test cases will be provided in the following multiline text format, using only half width characters. The first line contains one integer, C, which is the number of test cases that will follow. The second line is blank. From the third line onwards, the test cases separated by blank lines will follow. Each test case has the following format.

N
D
x1 y1
x2 y2
...
xD yD
N is the number of nodes and D is the number of direct connections. xi yi indicates that nodes xi and yi are directly connected. If there are multiple direct connections between a pair of nodes, they will all be listed.

## Limits

Number of test cases: 1 <= C <= 111
Number of nodes: 2 <= N <= 100
Number of connections: 0 <= D <= 100

## Output

For each test case, output one line containing the test case index, starting from 1, followed by a descending sequence of integers separated by a space.

The resulting line should be in this format:

Case #i: S1 S2 ...
where i is the index of the test case, and Sk are the sizes of the groups.

## Sample input

4
5
3
1 2
3 4
3 5
5
2
4 2
3 1
6
0
3
3
1 2
2 1
3 3

## Hint

In Case #1, the largest group {3,4,5} is of size 3 and the other group {1,2} has size 2.
In Case #2, you have two groups {1,3} and {2,4} of size 2, and a singleton group {5}.
In Case #3, since there is no direct connection, all six nodes form separate groups.
In Case #4, there are two connections between node 1 and 2, and there is a self-looping connection around node 3.

## Output for sample input

Case #1: 3 2
Case #2: 2 2 1
Case #3: 1 1 1 1 1 1
Case #4: 2 1
